#ifndef MAXON_REPLACEMEMHANDLER_H__
#define MAXON_REPLACEMEMHANDLER_H__

#include <utility>

using MallocPtr = void* (*)(std::size_t s);
using FreePtr = void(*)(void* p);

#ifdef __GNUC__
__attribute__((visibility("default"))) void SetMemoryHandlingFunctionPointers(MallocPtr mallocFunction, FreePtr freeFunction);
__attribute__((visibility("default"))) void ResetMemoryHandlingFunctionPointers();
#endif

#ifdef _WIN32
__declspec(dllimport) void SetMemoryHandlingFunctionPointers(MallocPtr mallocFunction, FreePtr freeFunction);
__declspec(dllimport) void ResetMemoryHandlingFunctionPointers();
#endif

#endif // MAXON_REPLACEMEMHANDLER_H__